/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.behaviour;

import java.util.EnumMap;
import technology.rocketjump.undermount.entities.components.AttachedLightSourceComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.mapping.tile.CompassDirection;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.mapping.tile.MapVertex;

public class AttachedLightSourceBehaviour {
    private static final float OUTDOOR_LIGHTING_AMOUNT_TO_TOGGLE_LIGHTSOURCE = 0.75f;

    public static void infrequentUpdate(GameContext gameContext, Entity parentEntity) {
        MapTile currentTile;
        AttachedLightSourceComponent attachedLightSourceComponent = parentEntity.getComponent(AttachedLightSourceComponent.class);
        if (attachedLightSourceComponent != null && (currentTile = gameContext.getAreaMap().getTile(parentEntity.getLocationComponent().getWorldPosition())) != null) {
            EnumMap<CompassDirection, MapVertex> vertexNeighboursOfCell = gameContext.getAreaMap().getVertexNeighboursOfCell(currentTile);
            float numVertices = 0.0f;
            float outdoorLight = 0.0f;
            for (MapVertex mapVertex : vertexNeighboursOfCell.values()) {
                numVertices += 1.0f;
                outdoorLight += mapVertex.getOutsideLightAmount();
            }
            float currentSunlightAmount = gameContext.getAreaMap().getEnvironment().getSunlightAmount();
            float nearbyLuminance = (outdoorLight /= numVertices) * currentSunlightAmount;
            if (nearbyLuminance > 0.75f) {
                attachedLightSourceComponent.setEnabled(false);
            } else {
                attachedLightSourceComponent.setEnabled(true);
            }
        }
    }
}

